import asyncio
import json
import logging
import os

import httpx
from discord import Client, TextChannel, utils

TOKENS: list[str] = [
    "",
]

session = httpx.AsyncClient()

msg: str = open("./data/msg.txt", "rt").read()

finished: bool = False


async def waiter():
    global finished

    while True:
        if finished:
            finished = False
            return

        await asyncio.sleep(1)


async def main():
    utils.setup_logging(level=logging.DEBUG)

    for token in TOKENS:
        bot = Client()

        @bot.event
        async def on_ready():
            global finished

            if bot.user:
                print("{}#{}として起動しました".format(bot.user.name, bot.user.discriminator))

                try:
                    guilds: list[int] = json.loads(
                        open("./data/guilds/{}.json".format(bot.user.id), "rt").read()
                    )
                except Exception as e:
                    print(e)

                    # finished = True
                    return

                for temp_guild in guilds:
                    print(str(temp_guild) + "の処理を開始します")

                    guild = await bot.fetch_guild(temp_guild, with_counts=False)

                    try:
                        pub_ch = utils.get(await guild.fetch_channels(), name="お知らせ")
                    except Exception as e:
                        print(e)
                        continue

                    if isinstance(pub_ch, TextChannel):
                        try:
                            await pub_ch.send(msg)
                            print("お知らせメッセを送信しました")
                        except Exception as e:
                            print(e)
                            continue
                    else:
                        print(pub_ch)

                print("すべて送信し終わった論破")
            else:
                print("botユーザーなかった")

            await bot.close()

            finished = True

        asyncio.ensure_future(bot.start(token, reconnect=False))

        await waiter()

    os._exit(1)


asyncio.run(main())
