import asyncio
import json

from discord import Client, SubCommand, TextChannel, utils

TOKEN: str = ""

DISSOKU_BOT_ID: int = 761562078095867916

bot = Client()


async def work():
    if bot.user:
        print("{}#{}として起動しました".format(bot.user.name, bot.user.discriminator))

        guilds: list[int] = json.loads(
            open("./data/guilds/{}.json".format(bot.user.id), "rt").read()
        )

        dissoku_regist_cmd: SubCommand | None = None
        dissoku_ci_cmd: SubCommand | None = None

        for temp_guild in guilds:
            guild = await bot.fetch_guild(temp_guild)

            print("[{}] 処理を開始します...".format(guild.id))

            channels = await guild.fetch_channels()

            pub_ch = utils.get(channels, name="お知らせ")

            cmd_ch = utils.get(channels, name="cmd")

            if isinstance(pub_ch, TextChannel) and isinstance(cmd_ch, TextChannel):
                print("[{}] {}, {}".format(guild.id, pub_ch.id, cmd_ch.id))

                if not (dissoku_regist_cmd and dissoku_ci_cmd):
                    async for slash in cmd_ch.slash_commands():
                        if (
                            slash.application_id == DISSOKU_BOT_ID
                            and slash.name == "dissoku"
                        ):
                            for sub in slash.children:
                                if sub.name == "regist":
                                    dissoku_regist_cmd = sub

                                    print(
                                        "[{}] /dissoku regist を取得しました".format(
                                            guild.id
                                        )
                                    )
                                elif sub.name == "ci":
                                    dissoku_ci_cmd = sub

                                    print(
                                        "[{}] /dissoku ci を取得しました".format(
                                            guild.id
                                        )
                                    )

                if dissoku_regist_cmd:
                    for failed_count in range(5):
                        try:
                            inter = await dissoku_regist_cmd.__call__(
                                cmd_ch, language="ja"
                            )

                            if inter.successful:
                                print(
                                    "[{}] /dissoku regist の実行に成功しました".format(
                                        guild.id
                                    )
                                )
                                break
                        except Exception as e:
                            print(e)

                        print(
                            "[{}] /dissoku regist の実行に{}回失敗しました".format(
                                guild.id, failed_count + 1
                            )
                        )

                        await asyncio.sleep(0.5)

                if dissoku_ci_cmd:
                    for failed_count in range(5):
                        try:
                            inter = await dissoku_ci_cmd.__call__(
                                cmd_ch, channel=pub_ch
                            )

                            if inter.successful:
                                print(
                                    "[{}] /dissoku ci の実行に成功しました".format(
                                        guild.id
                                    )
                                )
                                break
                        except Exception as e:
                            print(e)

                        print(
                            "[{}] /dissoku ci の実行に{}回失敗しました".format(
                                guild.id, failed_count + 1
                            )
                        )

                        await asyncio.sleep(0.5)
            else:
                print("[{}] チャンネルの取得に失敗しました".format(guild.id))
    else:
        print("botユーザーがなかった")

    await bot.close()


@bot.event
async def on_ready():
    await work()


if __name__ == "__main__":
    bot.run(TOKEN)
