import asyncio
import base64
import json
import sys

import tls_client
from discord import Client

DISSOKU_BOT_ID: int = 761562078095867916
TOKEN: str = sys.argv[1]

encoded_text = TOKEN.split(".")[0]

USER_ID: str = base64.b64decode(encoded_text + "=" * (-len(encoded_text) % 4)).decode()

bot = Client()
session = tls_client.Session(
    client_identifier="chrome112", random_tls_extension_order=True
)


async def main():
    print("{}として起動しました".format(USER_ID))

    guilds: list[int] = json.loads(
        open("./data/guilds/{}.json".format(USER_ID), "rt").read()
    )

    discord_callback_url: str = (
        await asyncio.to_thread(
            session.post,
            "https://discord.com/api/v9/oauth2/authorize?client_id=761562078095867916&response_type=code&redirect_uri=https://dissoku.net/accounts/discord/login/callback&scope=identify guilds",
            headers={
                "accept": "*/*",
                "accept-encoding": "",
                "accept-language": "ja",
                "authorization": TOKEN,
                "content-type": "application/json",
                "sec-ch-ua": '" Not A;Brand";v="99", "Chromium";v="102"',
                "sec-ch-ua-mobile": "?0",
                "sec-ch-ua-platform": '"Windows"',
                "sec-fetch-dest": "empty",
                "sec-fetch-mode": "cors",
                "sec-fetch-site": "same-origin",
                "user-agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.0.0 Safari/537.36",
                "x-super-properties": "eyJvcyI6IldpbmRvd3MiLCJicm93c2VyIjoiQ2hyb21lIiwiZGV2aWNlIjoiIiwic3lzdGVtX2xvY2FsZSI6ImphIiwiYnJvd3Nlcl91c2VyX2FnZW50IjoiTW96aWxsYS81LjAgKFdpbmRvd3MgTlQgMTAuMDsgV09XNjQpIEFwcGxlV2ViS2l0LzUzNy4zNiAoS0hUTUwsIGxpa2UgR2Vja28pIENocm9tZS8xMDIuMC4wLjAgU2FmYXJpLzUzNy4zNiIsImJyb3dzZXJfdmVyc2lvbiI6IjEwMi4wLjAuMCIsIm9zX3ZlcnNpb24iOiIxMCIsInJlZmVycmVyIjoiIiwicmVmZXJyaW5nX2RvbWFpbiI6IiIsInJlZmVycmVyX2N1cnJlbnQiOiIiLCJyZWZlcnJpbmdfZG9tYWluX2N1cnJlbnQiOiIiLCJyZWxlYXNlX2NoYW5uZWwiOiJzdGFibGUiLCJjbGllbnRfYnVpbGRfbnVtYmVyIjoyMDY1NzYsImNsaWVudF9ldmVudF9zb3VyY2UiOm51bGx9",
                "x-debug-options": "bugReporterEnabled",
                "x-discord-locale": "ja",
                "x-discord-timezone": "Asia/Tokyo",
            },
            json={"permissions": "0", "authorize": True},
        )
    ).json()["location"]

    await asyncio.to_thread(session.get, discord_callback_url)

    dissoku_callback_code: str = discord_callback_url.split("?code=")[1]

    dissoku_token: str = (
        "JWT "
        + (
            await asyncio.to_thread(
                session.post,
                "https://app.dissoku.net/rest-auth/discord/?lang=ja",
                headers={
                    "accept": "application/json, text/plain, */*",
                    "accept-language": "ja",
                    "authorization": "false",
                    "content-type": "application/json",
                    "sec-ch-ua": '" Not A;Brand";v="99", "Chromium";v="102"',
                    "sec-ch-ua-mobile": "?0",
                    "sec-ch-ua-platform": '"Windows"',
                    "sec-fetch-dest": "empty",
                    "sec-fetch-mode": "cors",
                    "sec-fetch-site": "same-site",
                    "referrer": "https://dissoku.net/",
                    "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36",
                },
                json={"code": dissoku_callback_code},
            )
        ).json()["access_token"]
    )

    for guild in guilds:
        for failed_count in range(5):
            try:
                res = await asyncio.to_thread(
                    session.patch,
                    "https://app.dissoku.net/api/guilds/{}/?lang=ja".format(guild),
                    headers={
                        "accept": "application/json, text/plain, */*",
                        "accept-language": "ja",
                        "authorization": dissoku_token,
                        "content-type": "application/json",
                        "sec-ch-ua": '" Not A;Brand";v="99", "Chromium";v="102"',
                        "sec-ch-ua-mobile": "?0",
                        "sec-ch-ua-platform": '"Windows"',
                        "sec-fetch-dest": "empty",
                        "sec-fetch-mode": "cors",
                        "sec-fetch-site": "same-site",
                        "referrer": "https://dissoku.net/",
                        "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36",
                    },
                    json={
                        "description": """所有権のアカウントが死んでしまったので、以下の招待リンクから移行先のサーバーに参加してください！
https://discord.gg/hikamani

Miffy鯖飛んだので入ってね！
https://discord.gg/ZN5bbDqx5u""",
                        "description_detail": "",
                        "display_flg": True,
                        "tags": ["雑談", "ゲーム", "通話", "初心者歓迎", "学生"],
                        "nsfw_flg": False,
                        "lang": "ja",
                    },
                )

                if res.status_code == 200:
                    print(
                        "[{}] dissokuでのプロフィール設定のリクエストに成功しました".format(
                            guild
                        )
                    )
                    await asyncio.sleep(0.5)
                    break
                else:
                    print(res.text)
                    print(res.status_code)
            except Exception as e:
                print(e)

            print(
                "[{}] {}回目のdissokuでのプロフィール設定のリクエストに失敗しました".format(
                    guild, failed_count + 1
                )
            )

            await asyncio.sleep(0.5)

    print("すべてのサーバーに説明を登録しました")


if __name__ == "__main__":
    asyncio.run(main())
