import asyncio
import atexit
import base64
import json
import os
import subprocess
import sys
import threading
import time

import httpx
import tls_client
from discord import Client, SubCommand, TextChannel, utils
from flask import Flask
from flask_socketio import SocketIO

bot = Client()
session = httpx.AsyncClient()
tls_session = tls_client.Session(
    client_identifier="chrome112", random_tls_extension_order=True
)

DISSOKU_BOT_ID: int = 761562078095867916

TOKEN: str = sys.argv[1]

encoded_text: str = TOKEN.split(".")[0]

USER_ID: str = base64.b64decode(encoded_text + "=" * (-len(encoded_text) % 4)).decode()

template_code: str = open("./data/template_code.txt", "rt").read()
msg: str = open("./data/msg.txt", "rt").read()
guild_name: str = open("./data/guild_name.txt", "rt").read()
icon_data: bytes = open("./data/icon.png", "rb").read()

hcaptcha_html: str = open("./data/hcaptcha.html", "rt").read()

print("設定の読み込みが完了しました")


app = Flask(__name__)
socketio = SocketIO(app, cors_allowed_origins="*")

captcha_keys: list[str] = []

guilds: list[int] = json.loads(
    open("./data/guilds/{}.json".format(USER_ID), "rt").read()
)
cmd_channels: list[int] = json.loads(
    open("./data/cmd_channels/{}.json".format(USER_ID), "rt").read()
)


@app.get("/")
async def root():
    return hcaptcha_html


@socketio.on("captcha_solved")
def on_captcha_solved(data):
    print(data["captcha_key"])

    captcha_keys.append(data["captcha_key"])


@atexit.register
def save_data():
    with open("./data/guilds/{}.json".format(USER_ID), "wt") as f:
        f.write(json.dumps(guilds, indent=4))

    with open("./data/cmd_channels/{}.json".format(USER_ID), "wt") as f:
        f.write(json.dumps(cmd_channels, indent=4))


async def work():
    if bot.user:
        print("{}#{}として起動しました".format(bot.user.name, bot.user.discriminator))

        dissoku_regist_cmd: SubCommand | None = None
        dissoku_ci_cmd: SubCommand | None = None

        new_servers: list[int] = []

        if 100 - len(guilds):
            threading.Thread(target=socketio.run, args=[app]).start()

        for i in range(100 - len(guilds)):
            try:
                guild = await bot.create_guild(guild_name, icon_data, template_code)
            except Exception as e:
                print(e)
                break

            guilds.append(guild.id)
            new_servers.append(guild.id)

            print("[{}] サーバーを作成しました：{}".format(i, guild_name))

            channels = await guild.fetch_channels()

            pub_ch = utils.get(channels, name="お知らせ")

            cmd_ch = utils.get(channels, name="cmd")

            if cmd_ch:
                cmd_channels.append(cmd_ch.id)

            headers = {
                "accept": "*/*",
                "accept-encoding": "",
                "accept-language": "ja",
                "authorization": TOKEN,
                "content-type": "application/json",
                "sec-ch-ua": '" Not A;Brand";v="99", "Chromium";v="102"',
                "sec-ch-ua-mobile": "?0",
                "sec-ch-ua-platform": '"Windows"',
                "sec-fetch-dest": "empty",
                "sec-fetch-mode": "cors",
                "sec-fetch-site": "same-origin",
                "user-agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.0.0 Safari/537.36",
                "x-super-properties": "eyJvcyI6IldpbmRvd3MiLCJicm93c2VyIjoiQ2hyb21lIiwiZGV2aWNlIjoiIiwic3lzdGVtX2xvY2FsZSI6ImphIiwiYnJvd3Nlcl91c2VyX2FnZW50IjoiTW96aWxsYS81LjAgKFdpbmRvd3MgTlQgMTAuMDsgV09XNjQpIEFwcGxlV2ViS2l0LzUzNy4zNiAoS0hUTUwsIGxpa2UgR2Vja28pIENocm9tZS8xMDIuMC4wLjAgU2FmYXJpLzUzNy4zNiIsImJyb3dzZXJfdmVyc2lvbiI6IjEwMi4wLjAuMCIsIm9zX3ZlcnNpb24iOiIxMCIsInJlZmVycmVyIjoiIiwicmVmZXJyaW5nX2RvbWFpbiI6IiIsInJlZmVycmVyX2N1cnJlbnQiOiIiLCJyZWZlcnJpbmdfZG9tYWluX2N1cnJlbnQiOiIiLCJyZWxlYXNlX2NoYW5uZWwiOiJzdGFibGUiLCJjbGllbnRfYnVpbGRfbnVtYmVyIjoyMDY1NzYsImNsaWVudF9ldmVudF9zb3VyY2UiOm51bGx9",
                "x-debug-options": "bugReporterEnabled",
                "x-discord-locale": "ja",
                "x-discord-timezone": "Asia/Tokyo",
            }

            while True:
                res = await session.post(
                    "https://discord.com/api/v9/oauth2/authorize?client_id=761562078095867916&scope=bot applications.commands",
                    headers=headers,
                    json={
                        "guild_id": str(guild.id),
                        "permissions": "8",
                        "authorize": True,
                    },
                )

                if res.status_code == 200:
                    print("作成したサーバーにdissoku botを追加しました")
                    print(res.text)
                    break
                else:
                    print("dissokuをサーバーに追加する際にCaptchaの要求を受けました")
                    print(res.text)

                    while True:
                        amount = len(captcha_keys)

                        print("{}個のCaptchaキーがあります".format(amount))

                        if amount:
                            print("Captchaキーがあるのでリクエストに使います")
                            break

                        await asyncio.sleep(0.5)

                    headers["x-captcha-key"] = captcha_keys.pop(0)

            print("[{}] 作成したサーバーにdissoku botを追加しました".format(i))

            if isinstance(pub_ch, TextChannel) and isinstance(cmd_ch, TextChannel):
                await pub_ch.send(msg)

                print("[{}] 作成したサーバーにテンプレメッセを送信しました".format(i))

                if not (dissoku_regist_cmd and dissoku_ci_cmd):
                    async for slash in cmd_ch.slash_commands():
                        if (
                            slash.application_id == DISSOKU_BOT_ID
                            and slash.name == "dissoku"
                        ):
                            for sub in slash.children:
                                if sub.name == "regist":
                                    dissoku_regist_cmd = sub

                                    print("[{}] /dissoku regist を取得しました".format(i))
                                elif sub.name == "ci":
                                    dissoku_ci_cmd = sub

                                    print("[{}] /dissoku ci を取得しました".format(i))

                if dissoku_regist_cmd:
                    for failed_count in range(5):
                        inter = await dissoku_regist_cmd.__call__(cmd_ch, language="ja")

                        if inter.successful:
                            print("[{}] /dissoku regist の実行に成功しました".format(i))
                            break

                        print(
                            "[{}] /dissoku regist の実行に{}回失敗しました".format(
                                i, failed_count + 1
                            )
                        )

                        await asyncio.sleep(0.5)

                await asyncio.sleep(0.5)

                if dissoku_ci_cmd:
                    for failed_count in range(5):
                        inter = await dissoku_ci_cmd.__call__(cmd_ch, channel=pub_ch)

                        if inter.successful:
                            print("[{}] /dissoku ci の実行に成功しました".format(i))
                            break

                        print("[{}] /dissoku ci の実行に{failed_count+1}回失敗しました".format(i))

                        await asyncio.sleep(0.5)

        with open("./data/guilds/{}.json".format(bot.user.id), "wt") as f:
            f.write(json.dumps(guilds, indent=4))

        with open("./data/cmd_channels/{}.json".format(bot.user.id), "wt") as f:
            f.write(json.dumps(cmd_channels, indent=4))

        print("{}サーバーを作成しました".format(len(new_servers)))

        if len(new_servers):
            subprocess.run(
                " ".join(["python3", "dissoku_description.py", TOKEN]),
                shell=True,
                stdout=sys.stdout,
            )

        dissoku_up_cmd: SubCommand | None = None

        start_time: float = time.perf_counter()

        for i, temp_channel in enumerate(cmd_channels, 1):
            print("{}回目の /dissoku upを開始します...".format(i))

            try:
                cmd_ch = await bot.fetch_channel(temp_channel)
            except:
                print("{}回目の /dissoku upを実行するチャネルの取得に失敗しました".format(i))
                continue

            if isinstance(cmd_ch, TextChannel):
                if not dissoku_up_cmd:
                    async for slash in cmd_ch.slash_commands():
                        if (
                            slash.application_id == DISSOKU_BOT_ID
                            and slash.name == "dissoku"
                        ):
                            for sub in slash.children:
                                if sub.name == "up":
                                    dissoku_up_cmd = sub

                                    print("[{}] /dissoku up を取得しました".format(i))

                if dissoku_up_cmd:
                    for failed_count in range(1, 6):
                        try:
                            inter = await dissoku_up_cmd.__call__(cmd_ch)

                            if inter.successful:
                                print("[{}] /dissoku up の実行に成功しました".format(i))
                                break
                        except:
                            continue

                        print("[{}] /dissoku up の実行に{}回失敗しました".format(i, failed_count))

                        await asyncio.sleep(0.5)

            if i and not i % 15:
                print("{}回目の/dissoku up 1ページ分が実行し終わりました".format(i // 15))

                delay = time.perf_counter()

                if delay < start_time + 60:
                    await asyncio.sleep(start_time + 60 - delay)

                start_time = time.perf_counter()

        print("すべての/disoku up が完了したのでワーカーを終了します...")
    else:
        print("botユーザーなかった")

    sys.stderr.write("END_PROCESS\n")


@bot.event
async def on_ready():
    await work()


if __name__ == "__main__":
    bot.run(TOKEN)
