import asyncio
import json
import threading

import httpx
from discord import Client, TextChannel, utils
from flask import Flask
from flask_socketio import SocketIO

TOKEN = ""

bot = Client()
session = httpx.AsyncClient()

app = Flask(__name__)
socketio = SocketIO(app, cors_allowed_origins="*")

captcha_keys: list[str] = []

hcaptcha_html = open("./data/hcaptcha.html", "rt").read()


@app.get("/")
async def root():
    return hcaptcha_html


@socketio.on("captcha_solved")
def on_captcha_solved(data):
    print(data["captcha_key"])

    captcha_keys.append(data["captcha_key"])


@bot.event
async def on_ready():
    if bot.user:
        guilds: list[int] = json.loads(
            open("./data/guilds/{}.json".format(bot.user.id), "rt").read()
        )

        for temp_guild in guilds:
            print(str(temp_guild) + "の処理を開始します")
            guild = await bot.fetch_guild(temp_guild, with_counts=False)

            try:
                await guild.fetch_member(761562078095867916)

                print("dissokuはこのサーバーに居ました")

                pub_ch = utils.get(guild.channels, name="お知らせ")

                if isinstance(pub_ch, TextChannel) and pub_ch.last_message:
                    if pub_ch.last_message:
                        await pub_ch.last_message.delete()
                        print("dissokuのよろしくメッセを削除しました")
            except:
                print("dissokuをサーバーに追加します")

                headers = {
                    "accept": "*/*",
                    "accept-encoding": "",
                    "accept-language": "ja",
                    "authorization": TOKEN,
                    "content-type": "application/json",
                    "sec-ch-ua": '" Not A;Brand";v="99", "Chromium";v="102"',
                    "sec-ch-ua-mobile": "?0",
                    "sec-ch-ua-platform": '"Windows"',
                    "sec-fetch-dest": "empty",
                    "sec-fetch-mode": "cors",
                    "sec-fetch-site": "same-origin",
                    "user-agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.0.0 Safari/537.36",
                    "x-super-properties": "eyJvcyI6IldpbmRvd3MiLCJicm93c2VyIjoiQ2hyb21lIiwiZGV2aWNlIjoiIiwic3lzdGVtX2xvY2FsZSI6ImphIiwiYnJvd3Nlcl91c2VyX2FnZW50IjoiTW96aWxsYS81LjAgKFdpbmRvd3MgTlQgMTAuMDsgV09XNjQpIEFwcGxlV2ViS2l0LzUzNy4zNiAoS0hUTUwsIGxpa2UgR2Vja28pIENocm9tZS8xMDIuMC4wLjAgU2FmYXJpLzUzNy4zNiIsImJyb3dzZXJfdmVyc2lvbiI6IjEwMi4wLjAuMCIsIm9zX3ZlcnNpb24iOiIxMCIsInJlZmVycmVyIjoiIiwicmVmZXJyaW5nX2RvbWFpbiI6IiIsInJlZmVycmVyX2N1cnJlbnQiOiIiLCJyZWZlcnJpbmdfZG9tYWluX2N1cnJlbnQiOiIiLCJyZWxlYXNlX2NoYW5uZWwiOiJzdGFibGUiLCJjbGllbnRfYnVpbGRfbnVtYmVyIjoyMDY1NzYsImNsaWVudF9ldmVudF9zb3VyY2UiOm51bGx9",
                    "x-debug-options": "bugReporterEnabled",
                    "x-discord-locale": "ja",
                    "x-discord-timezone": "Asia/Tokyo",
                }

                while True:
                    res = await session.post(
                        "https://discord.com/api/v9/oauth2/authorize?client_id=761562078095867916&scope=bot applications.commands",
                        headers=headers,
                        json={
                            "guild_id": str(guild.id),
                            "permissions": "2147550209",
                            "authorize": True,
                        },
                    )

                    if res.status_code == 200:
                        print("作成したサーバーにdissoku botを追加しました")
                        print(res.text)
                        break
                    else:
                        print("dissokuをサーバーに追加する際にCaptchaの要求を受けました")
                        print(res.text)

                        while True:
                            amount = len(captcha_keys)

                            print("{}個のCaptchaキーがあります".format(amount))

                            if amount:
                                print("Captchaキーがあるのでリクエストに使います")
                                break

                            await asyncio.sleep(0.5)

                        headers["x-captcha-key"] = captcha_keys.pop(0)

                pub_ch = utils.get(guild.channels, name="お知らせ")

                if isinstance(pub_ch, TextChannel):
                    while True:
                        if pub_ch.last_message:
                            await pub_ch.last_message.delete()
                            break

                        await asyncio.sleep(0.25)

                print("dissokuのよろしくメッセを削除しました")
    else:
        print("botユーザーがなかった")

    await bot.close()


async def main():
    threading.Thread(target=bot.run, args=[TOKEN]).start()

    socketio.run(app)


if __name__ == "__main__":
    asyncio.run(main())
