import json

from discord import Client, utils

TOKEN = ""

bot = Client()


@bot.event
async def on_ready():
    if bot.user:
        print("{}#{}として起動しました".format(bot.user.name, bot.user.discriminator))

        guilds = await bot.fetch_guilds()

        with open("./data/guilds/{}.json".format(bot.user.id), "wt") as f:
            f.write(json.dumps(list(map(lambda d: d.id, guilds)), indent=4))

        cmd_channels: list[int] = []

        for temp_guild in guilds:
            print(temp_guild.id)

            guild = await bot.fetch_guild(temp_guild.id)

            cmd_channel = utils.get(await guild.fetch_channels(), name="cmd")

            if cmd_channel:
                print("[{}] {}".format(guild.id, cmd_channel.id))

                cmd_channels.append(cmd_channel.id)

        with open("./data/cmd_channels/{}.json".format(bot.user.id), "wt") as f:
            f.write(json.dumps(cmd_channels, indent=4))

        print("すべてのサーバーとチャネルを保存しました")
    else:
        print("botユーザーなかった")

    await bot.close()


bot.run(TOKEN)
